/**
 * Beschrijft het personage Indiaan van een computergame.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-04-12
 */
public class Indiaan extends Strijder
{

    /**
     * Constructor voor objecten van de klasse Indiaan.
     * @param   naam    De naam van de Indiaan.
     */
    public Indiaan(String naam)
    {
        super(naam);
        aantalLevens = 5;
    }
    
    /**
     * Laat de Indiaan een vredespijp roken met een andere strijder.
     * @param   strijder    De strijder waarmee de vredespijp gerookt wordt.
     */
    public void rookVredesPijp(Strijder strijder)
    {
        if(strijder != null)
        {
            aantalLevens++;
        }
    }
    
    /**
     * Vermindert de gezondheidstoestand van de Indiaan.
     */
    public void geraakt()
    { 
        if(aantalLevens > 0)
        {
            aantalLevens--;
            gezondheid = 100;
        }
        else
        {
            gezondheid = 0;
        }
    }
}
 